<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BlockedExtensionResource\Pages;
use App\Filament\Resources\BlockedExtensionResource\RelationManagers;
use App\Models\BlockedExtension;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BlockedExtensionResource extends Resource
{
    protected static ?string $model = BlockedExtension::class;

    protected static ?string $navigationIcon = 'tabler-eye-cancel';
    protected static ?string $navigationLabel = 'Blocked Extensions';
    protected static ?string $navigationGroup = 'Extension';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('ext_name')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('ext_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBlockedExtensions::route('/'),
            // 'create' => Pages\CreateBlockedExtension::route('/create'),
            // 'edit' => Pages\EditBlockedExtension::route('/{record}/edit'),
        ];
    }
}
