<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BlockedSectionResource\Pages;
use App\Filament\Resources\BlockedSectionResource\RelationManagers;
use App\Models\BlockedSection;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BlockedSectionResource extends Resource
{
    protected static ?string $model = BlockedSection::class;

    protected static ?string $navigationIcon = 'tabler-eye-cancel';
    protected static ?string $navigationLabel = 'Blocked Section';
    protected static ?string $navigationGroup = 'Extension';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('section_name')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('section_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBlockedSections::route('/'),
            // 'create' => Pages\CreateBlockedSection::route('/create'),
            // 'edit' => Pages\EditBlockedSection::route('/{record}/edit'),
        ];
    }
}
