<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Invoice;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Database\Eloquent\Builder;
use App\Filament\Resources\InvoiceResource\Pages;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\InvoiceResource\RelationManagers;

class InvoiceResource extends Resource
{
    protected static ?string $model = Invoice::class;

    protected static ?string $navigationIcon = 'tabler-invoice';

    public static function canCreate(): bool
    {
        return false;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('code')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('phone_number')
                    ->tel()
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('product_id')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('status')
                    ->required()
                    ->numeric()
                    ->default(0),
                // Forms\Components\TextInput::make('send_sms')
                //     ->required()
                //     ->numeric()
                //     ->default(0),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('code')
                    ->searchable(),
                Tables\Columns\TextColumn::make('phone_number')
                    ->searchable(),



                Tables\Columns\TextColumn::make('type')
                    ->label('Package')
                    ->getStateUsing(function ($record) {
                        switch ($record->type) {
                            case 1:
                                return 'Package';
                            case 2:
                                return 'Bundle';
                            default:
                                return 'Unknown';
                        }
                    })->description(
                        function ($record) {
                            switch ($record->type) {
                                case 1:
                                    return $record->package->title;
                                case 2:
                                    return $record->bundle->title;
                                default:
                                    return 'Unknown';
                            }
                        }
                    )->words(5, '...'),



                Tables\Columns\TextColumn::make('time_period')
                    ->label('Time Period')
                    ->getStateUsing(function ($record) {
                        switch ($record->type) {
                            case 1:
                                return 'Package';
                            case 2:
                                return 'Bundle';
                            default:
                                return 'Unknown';
                        }
                    })->description(
                        function ($record) {
                            switch ($record->type) {
                                case 1:
                                    return $record->package_time_period->title;
                                case 2:
                                    return $record->mega_bundle_time_period->title;
                                default:
                                    return 'Unknown';
                            }
                        }
                    ),




                Tables\Columns\TextColumn::make('price')
                    ->label('Price')
                    ->getStateUsing(function ($record) {
                        switch ($record->type) {
                            case 1:
                                return $record->package_time_period->price;
                            case 2:
                                return $record->mega_bundle_time_period->price;
                            default:
                                return 'Unknown';
                        }
                    }),








                IconColumn::make('status')
                    ->boolean()
                    ->trueIcon('heroicon-o-check-badge')
                    ->falseIcon('heroicon-o-x-mark'),


                // IconColumn::make('send_sms')
                //     ->boolean()
                //     ->trueIcon('heroicon-o-check-badge')
                //     ->falseIcon('heroicon-o-x-mark'),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])->defaultSort('updated_at', 'desc')
            ->filters([
                SelectFilter::make('status')
                    ->options([
                        '0' => 'Pending',
                        '1' => 'Paid',

                    ])
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
                // Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvoices::route('/'),
            // 'create' => Pages\CreateInvoice::route('/create'),
            // 'edit' => Pages\EditInvoice::route('/{record}/edit'),

        ];
    }
}
