<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Package;
use Filament\Forms\Form;
use App\Models\MegaBundle;
use Filament\Tables\Table;
use Illuminate\Support\Str;
use Filament\Resources\Resource;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\MegaBundleResource\Pages;
use App\Filament\Resources\MegaBundleResource\RelationManagers;

class MegaBundleResource extends Resource
{
    protected static ?string $model = MegaBundle::class;

    protected static ?string $navigationIcon = 'tabler-package';



    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')->required()->live(onBlur: true)->maxLength(255)
                    ->afterStateUpdated(fn(string $operation, $state, Forms\Set $set) => $operation === 'create' ? $set('slug', Str::slug($state)) : null),

                Forms\Components\TextInput::make('slug')->disabled()->dehydrated()->required()->maxLength(255)->unique(MegaBundle::class, 'slug', ignoreRecord: true),

                Forms\Components\Textarea::make('summary')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('details')->required()->columnSpanFull(),
                Forms\Components\FileUpload::make('image')->directory('bundle-logo')->image()->imageResizeTargetHeight('1200')->imageResizeTargetWidth('600')->columnSpanFull(),
                Forms\Components\TextInput::make('old_price')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('new_price')
                    ->required() 
                    ->numeric(),
                Forms\Components\Select::make('Package')
                    ->label('Package')
                    ->relationship('package', 'title') // Assumes `name` column exists in `websites` table
                    ->multiple()
                    ->preload()
                    ->required(),
                Forms\Components\Toggle::make('status')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')->words(5)
                    ->searchable(),

                Tables\Columns\ImageColumn::make('image'),
                Tables\Columns\TextColumn::make('old_price')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('new_price')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('paid_invoices_count')
                    ->label('Total Sell')
                    ->counts('paid_invoices')
                    ->sortable(),

                Tables\Columns\TextColumn::make('packages_count')
                    ->label('Packages')
                    ->counts('packages')
                    ->sortable(),




                Tables\Columns\ToggleColumn::make('status'),


                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                // Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMegaBundles::route('/'),
            // 'create' => Pages\CreateMegaBundle::route('/create'),
            // 'edit' => Pages\EditMegaBundle::route('/{record}/edit'),
        ];
    }
}
