<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PackageCookiesResource\Pages;
use App\Filament\Resources\PackageCookiesResource\RelationManagers;
use App\Models\PackageCookies;
use Filament\Forms;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PackageCookiesResource extends Resource
{
    protected static ?string $model = PackageCookies::class;

    protected static ?string $navigationIcon = 'tabler-lock';
    protected static ?string $navigationLabel = 'Cookies';
    protected static ?string $navigationGroup = 'Extension';
    protected static ?string $pluralLabel = 'Cookies';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('package_id')
                    ->label('Website Name')
                    ->relationship('package', 'short_name')
                    ->unique(ignoreRecord: true)
                    ->required(),
                Forms\Components\TextInput::make('cookie_name')
                    ->required()
                    ->maxLength(255),
                Forms\Components\Textarea::make('cookie_value')
                    ->required()->rows(6)->columnSpanFull(),
                Forms\Components\Toggle::make('status')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('package.short_name')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('cookie_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('cookie_value')->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),
                Tables\Columns\ToggleColumn::make('status'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPackageCookies::route('/'),
            // 'create' => Pages\CreatePackageCookies::route('/create'),
            // 'edit' => Pages\EditPackageCookies::route('/{record}/edit'),
        ];
    }
}
