<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PackageCredentialResource\Pages;
use App\Filament\Resources\PackageCredentialResource\RelationManagers;
use App\Models\PackageCredential;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PackageCredentialResource extends Resource
{
    protected static ?string $model = PackageCredential::class;

    protected static ?string $navigationIcon = 'tabler-lock';
    protected static ?string $navigationLabel = 'Credentials';
    protected static ?string $navigationGroup = 'Extension';
    protected static ?string $pluralLabel = 'Credentials';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('package_id')
                    ->label('Website Name')
                    ->relationship('package', 'short_name')
                    ->required(),

                Forms\Components\TextInput::make('credential_name')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('password')
                    ->required()
                    ->maxLength(255),
                Forms\Components\Toggle::make('status')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table

            ->columns([
                Tables\Columns\TextColumn::make('package.short_name')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('credential_name')->searchable(),
                Tables\Columns\TextColumn::make('email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('password')
                    ->searchable(),
                Tables\Columns\ToggleColumn::make('status'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPackageCredentials::route('/'),
            // 'create' => Pages\CreatePackageCredential::route('/create'),
            // 'edit' => Pages\EditPackageCredential::route('/{record}/edit'),
        ];
    }
}
