<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Package;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Illuminate\Support\Str;
use Filament\Resources\Resource;
use Filament\Forms\Components\Toggle;
use Filament\Tables\Columns\IconColumn;
use Illuminate\Database\Eloquent\Builder;
use App\Filament\Resources\PackageResource\Pages;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\PackageResource\RelationManagers;

class PackageResource extends Resource
{
    protected static ?string $model = Package::class;

    protected static ?string $navigationIcon = 'tabler-box';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Forms\Components\TextInput::make('title')->required()->live(onBlur: true)->maxLength(255)
                    ->afterStateUpdated(fn(string $operation, $state, Forms\Set $set) => $operation === 'create' ? $set('slug', Str::slug($state)) : null),
                Forms\Components\TextInput::make('slug')->disabled()->dehydrated()->required()->maxLength(255)->unique(Package::class, 'slug', ignoreRecord: true),
                Forms\Components\TextInput::make('short_name')->required(),
                Forms\Components\TextInput::make('website')->required(),
                Forms\Components\Textarea::make('summary')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('details')->columnSpanFull(),

                Forms\Components\FileUpload::make('image')->directory('package-logo')->image()->imageResizeTargetHeight('1200')->imageResizeTargetWidth('600')->columnSpanFull(),
                Forms\Components\TextInput::make('old_price')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('new_price')
                    ->required()
                    ->numeric(),
                Forms\Components\Select::make('type')
                    ->options([
                        '1' => 'Cookies',
                        '2' => 'Email & Password',
                    ]),
                Toggle::make('status')
                    ->onColor('success')
                    ->offColor('danger')
                    ->label('Status'),
                Toggle::make('featured')
                    ->onColor('success')
                    ->offColor('danger')
                    ->label('Featured'),

                // Forms\Components\RichEditor::make('storage_link')->label('Storage Links')->columnSpanFull()


            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')->words(3)
                    ->searchable(),
                // Tables\Columns\TextColumn::make('short_name')
                //     ->searchable(),
                Tables\Columns\TextColumn::make('website')->limit(5)
                    ->searchable(),
                Tables\Columns\ImageColumn::make('image'),
                // Tables\Columns\TextColumn::make('old_price')
                //     ->numeric()
                //     ->sortable(),
                Tables\Columns\TextColumn::make('new_price')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('paid_invoices_count')
                    ->label('Sell')
                    ->counts('paid_invoices')
                    ->sortable(),
                Tables\Columns\TextColumn::make('cookies_count')
                    ->label('Cookies')
                    ->counts('cookies')
                    ->sortable(),
                // Tables\Columns\TextColumn::make('block_link_count')
                //     ->label('Links')
                //     ->counts('blockLink')
                //     ->sortable(),
                Tables\Columns\ToggleColumn::make('status'),
                Tables\Columns\ToggleColumn::make('featured'),
                Tables\Columns\TextColumn::make('slug')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\SelectColumn::make('type')
                    ->options([
                        '1' => 'Cookies',
                        '2' => 'Email & Password',
                    ]),
                // Tables\Columns\TextColumn::make('storage_link')->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPackages::route('/'),
            // 'create' => Pages\CreatePackage::route('/create'),
            // 'edit' => Pages\EditPackage::route('/{record}/edit'),
        ];
    }
}
