<?php

use App\Models\User;
use GuzzleHttp\Client;
use App\Models\Setting;
use App\Models\StaticPage;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cache;


function test()
{
    echo "hello";
}



function sendSMSOTP($mobile, $otp)
{
    // Set message and sender based on the given category
    $data = [
        'UserName' => 'emoholshop@gmail.com',    // Replace with actual Username
        'Apikey' => '81NEZW8GLJWM5JK',           // Replace with actual API Key
        'MobileNumber' => '88' . $mobile,       // Get mobile number from request
        'SenderName' => '8809601002655',  // Sender name
        'TransactionType' => 'T',                // Transaction type
        'Message' => "Emohol your login OTP code is " . $otp  // Message content
    ];
    // Initialize HTTP client
    $client = new Client();
    try {
        // Send the GET request to the SMS API
        $response = $client->get('https://api.mimsms.com/api/SmsSending/Send', ['query' => $data]);

        // Return the response in a structured format
        return [
            'success' => $response->getStatusCode() == 200,
            'message' => $response->getStatusCode() == 200 ? 'SMS sent successfully' : 'Failed to send SMS',
            'data' => json_decode($response->getBody(), true)
        ];
    } catch (\Exception $e) {
        // Handle exceptions
        return [
            'success' => false,
            'message' => 'Error: ' . $e->getMessage(),
            'data' => [
                'statusCode' => $e->getCode(),
                'status' => 'Server Error',
                'responseResult' => 'Unknown Error occurred, please try again'
            ]
        ];
    }
}


function static_pages()
{
    return Cache::remember('static_pages', now()->addSeconds(10), function () {
        return StaticPage::where('status', 1)->get();
    });
}

function custom_setings()
{

    return Cache::remember('custom_setings', now()->addSeconds(10), function () {
        return Setting::where('id', 1)->first();
    });
}

function user_access_lists(int $auth_id): array
{

    $user = User::where('id', $auth_id)->with('paid_invoice')->firstorfail();
    $invoices = $user->paid_invoice;
    if ($invoices->count() == 0) {
        return [];
    } else {
        $web_lists = [];
        foreach ($invoices as $invoice) {
            if ($invoice->type == 1) {
                $period = $invoice->package_time_period->day;
                $period = intval($period);
                $available_time = $invoice->updated_at->addDays($period);
                if ($available_time > now()) {
                    $web_lists['package_id'][] = $invoice->product_id;
                }
            }
            if ($invoice->type == 2) {
                $period = intval($invoice->mega_bundle_time_period->day);
                $available_time = $invoice->updated_at->addDays($period);
                if ($available_time > now()) {
                    $packages = $invoice->bundle->package;
                    foreach ($packages as $package) {
                        $web_lists['package_id'][] = $package->id;
                    }
                }
            }
        }
    }
    $package_ids = array_unique($web_lists['package_id']);
    return $package_ids;
}

function fsendEvent($eventName, $userData = [], $price = 0)
{
    $pixelId = '515633051337182';
    $accessToken = 'EAAMsZCZBRXao8BO99AxaK2DOJ8cld38Y70TjAVAl2PavrHw67mCcyEZCM2ITl1t8JIqAgUOSnRwuWsAZCTP2r8X6PIx9TxUXMi07CtxVsFBQka5fNGjS6lpmmypZBy4rZAuOZCBPr0yBIAkCm76a5IWDdZCbwUP25qRHcf07CiGA5cVfkTORXuqlugl3YZCPvR0d7AAZDZD';

    $endpoint = "https://graph.facebook.com/v18.0/{$pixelId}/events";

    $eventData = [
        'data' => [
            [
                'event_name' => $eventName,
                'event_time' => time(),
                'user_data' => $userData,
                'action_source' => 'website',
                'currency' => 'BDT',
                'value' => $price
            ]
        ],
        'access_token' => $accessToken
    ];

    $response = Http::post($endpoint, $eventData);

    return $response->json();
}
