<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Invoice;
use App\Models\Package;
use Illuminate\Http\Request;
use App\Models\BlockedSection;
use App\Models\BlockedExtension;
use Illuminate\Support\Facades\Cache;
use App\Http\Resources\PackageResource;

class ApiController extends Controller
{


    public function authExt(Request $request)
    {
        $request->validate([
            'phone' => 'required',
        ]);
        $user = User::where('phone_number', $request->phone)->first();
        $blocked_extensions = BlockedExtension::all()->pluck('ext_name');
        $blocked_sections = BlockedSection::all()->pluck('section_name');
        if ($user) {
            return [
                'status' => 'success',
                'message' => 'Login successfully',
                'token' => [
                    'access_token' => $user->createToken('token')->plainTextToken,
                    'type' => 'Bearer',
                    'expires_in' => time()
                ],
                'config' => [
                    'blocked_extensions' => $blocked_extensions,
                    'hidden_ids' => [
                        '.access_link_table',
                        'access_button_2',
                    ],
                    'blocked_ids' => $blocked_sections
                ]
            ];
        }


        return [
            'status' => 'error',
            'message' => 'Unauthorized',
        ];
    }

    public function configExt(Request $request)
    {
        //$phone_number = $request->user()->phone_number;

        $user_id = auth()->user()->id;
        // $invoice = Invoice::where('phone_number', $phone_number)->get();


        $package_ids = user_access_lists($user_id);
        $package = Package::whereIn('id', $package_ids)->with('lastupdatedcookie')->get();


        // $package = Cache::remember('package', 100, function () {
        //     return Package::where('status', 1)->with('cookies')->get();
        // });
        $blocked_extensions = BlockedExtension::all()->pluck('ext_name');
        $blocked_sections = BlockedSection::all()->pluck('section_name');
        $sites = $package;
        return [
            'blocked_extensions' => $blocked_extensions,
            'hidden_ids' => [
                '.access_link_table',
                'access_button_2',
            ],
            'blocked_ids' => $blocked_sections,

            'sites' => PackageResource::collection($sites)
        ];
    }

    public function profileExt(Request $request)
    {
        return [
            // 'name' => auth()->user()->name,
            'name' => 'Emohol User',
            'phone' => auth()->user()->phone_number,
            // 'image' => 'https://ui-avatars.com/api/?name=' . auth()->user()->name,
            'image' => 'https://emohol.xyz/favicon/ms-icon-310x310.png',

        ];
    }
}
