<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Invoice;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\PaymentHistory;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class BkashController extends Controller
{
    private $base_url;
    public function __construct()
    {
        // Sandbox Base URL
        //$this->base_url = 'https://checkout.sandbox.bka.sh/v1.2.0-beta';
        // Live Base URL
        $this->base_url = 'https://checkout.pay.bka.sh/v1.2.0-beta';
    }
    public function authHeaders()
    {
        return array(
            'Content-Type:application/json',
            'Authorization:' . $this->grant(),
            'X-APP-Key:' . config('custom.BKASH_CHECKOUT_APP_KEY')
        );
    }
    public function curlWithBody($url, $header, $method, $body_data_json)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body_data_json);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
    public function curlWithoutBody($url, $header, $method)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
    public function grant()
    {
        $header = array(
            'Content-Type:application/json',
            'username:' . config('custom.BKASH_CHECKOUT_USER_NAME'),
            'password:' . config('custom.BKASH_CHECKOUT_PASSWORD')
        );
        $header_data_json = json_encode($header);
        $body_data = array('app_key' => config('custom.BKASH_CHECKOUT_APP_KEY'), 'app_secret' => config('custom.BKASH_CHECKOUT_APP_SECRET'));
        $body_data_json = json_encode($body_data);
        $response = $this->curlWithBody('/checkout/token/grant', $header, 'POST', $body_data_json);
        $token = json_decode($response)->id_token;
        return $token;
    }
    public function payment(Request $request)
    {
        $amount = 10;
        Session::put('payment_amount', $amount);
        return view('Iframe.pay')->with([
            'amount' => $amount,
        ]);
    }
    public function createPayment(Request $request)
    {
        $invoice_id = $request->invoice_id;
        $invoice = Invoice::where('code', $invoice_id)->first();
        if ($invoice) {
            $price = $invoice->type == 1 ? $invoice->package->new_price : $invoice->bundle->new_price;
            $total_price = $invoice->month_available == 0 ? $price : $price * $invoice->month_available;
            $invoice_price = $total_price;
            $header = $this->authHeaders();
            $body_data = array(
                'amount' => $invoice_price,
                'invoice' => $invoice_id,
                'currency' => 'BDT',
                'intent' => 'sale',
                'merchantInvoiceNumber' => "Inv" . Str::random(4)
            );
            $body_data_json = json_encode($body_data);
            $response = $this->curlWithBody('/checkout/payment/create', $header, 'POST', $body_data_json);
            Session::put('paymentID', json_decode($response)->paymentID);
            Session::put('invoiceID', $invoice_id);
            $response = json_decode($response);
            $response->orgName = "THE TOLET DOT COM";
            //$response->orgLogo = asset('images/thetolet-small-logo.webp');
            $response = json_encode($response);
            return $response;
        }
    }
    public function executePayment(Request $request)
    {
        $paymentID = Session::get('paymentID');
        $invoiceID = Session::get('invoiceID');
        $header = $this->authHeaders();
        $response = $this->curlWithoutBody('/checkout/payment/execute/' . $paymentID, $header, 'POST');
        $arr = json_decode($response, true);
        if (array_key_exists("errorCode", $arr) && $arr['errorCode'] != '0000') {
            Session::put('errorMessage', $arr['errorMessage']);
        } else if (array_key_exists("message", $arr)) {
            sleep(1);
            $response = $this->queryIframe($paymentID);
        }
        Session::put('response', $response);
        $response_arr = json_decode($response, true);
        if (isset($response_arr['trxID'])) {
            Invoice::where(['code' => $invoiceID])->update(['status' => 1]);
            PaymentHistory::create([
                'invoice_id' => $invoiceID,
                'payment_id' => $response_arr['paymentID'],
                'amount' => $response_arr['amount'],
                'trx_id' => $response_arr['trxID'],
                'payment_number' => $response_arr['customerMsisdn'],
                'gateway_name' => 'Bkash',
            ]);
            $invoice = Invoice::where('code', $invoiceID)->first();
            $user = User::where('phone_number', $invoice->phone_number)->first();
            if ($user) {
                $credentials = [
                    'phone_number' => $user->phone_number,
                    'password' => $user->verification_code,
                ];
                auth()->attempt($credentials);
            } else {
                $code = rand(100000, 999999);
                $user = User::create([
                    'name' => 'Anonymous',
                    'phone_number' => $invoice->phone_number,
                    'email' => rand(1111111111, 9999999999) . '@gmail.com',
                    'password' => Hash::make($code),
                    'verification_code' => $code,
                ]);
                $credentials = [
                    'phone_number' => $invoice->phone_number,
                    'password' => $code,
                ];
                auth()->attempt($credentials);
            }
        }
        return $response;
    }
    public function queryIframe($paymentID)
    {
        $header = $this->authHeaders();
        $response = $this->curlWithoutBody('/checkout/payment/query/' . $paymentID, $header, 'GET');
        return $response;
    }
    public function successPayment(Request $request)
    {
        return redirect(route('profile.index'))->with(['alert' => 'success', 'title' => 'Payment Successful', 'muted' => 'Thank you for buy the package']);
    }
    public function failPayment(Request $request)
    {
        return view('Iframe.fail')->with([
            'errorMessage' => Session::get('errorMessage')
        ]);
    }
    public function getRefund(Request $request)
    {
        return view('Iframe.refund');
    }
    public function refundPayment(Request $request)
    {
        $header = $this->authHeaders();
        $body_data = array(
            'paymentID' => $request->paymentID,
            'amount' => $request->amount,
            'trxID' => $request->trxID,
            'sku' => 'sku',
            'reason' => 'Quality issue'
        );
        $body_data_json = json_encode($body_data);
        $response = $this->curlWithBody('/checkout/payment/refund', $header, 'POST', $body_data_json);
        $arr = json_decode($response, true);
        return view('Iframe.refund')->with([
            'response' => $response,
        ]);
    }
}
