<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Invoice;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\PaymentHistory;
use Illuminate\Support\Facades\Hash;
use Karim007\LaravelBkashTokenize\Facade\BkashRefundTokenize;
use Karim007\LaravelBkashTokenize\Facade\BkashPaymentTokenize;

class BkashTokenizePaymentController extends Controller
{
    public function index()
    {
        return view('bkashT::bkash-payment');
    }
    public function createPayment(Request $request)
    {

        // dd($request->all());



        $invoice_id = $request->invoice_id;
        $invoice = Invoice::where('code', $invoice_id)->first();
        // dump($invoice_id);
        if ($invoice) {
            $price = $invoice->type == 1 ? $invoice->package->new_price : $invoice->bundle->new_price;
            //$total_price = $invoice->month_available == 0 ? $price : $price * $invoice->month_available;


            $time_period = $invoice->type == 1 ? $invoice->package_time_period : $invoice->mega_bundle_time_period;
            $invoice_price = $time_period->price;

            $request['intent'] = 'sale';
            $request['mode'] = '0011'; //0011 for checkout
            $request['payerReference'] = $invoice_id;
            $request['currency'] = 'BDT';
            $request['amount'] = $invoice_price;
            $request['merchantInvoiceNumber'] = $invoice_id;
            $request['callbackURL'] = config("bkash.callbackURL");;
            $request_data_json = json_encode($request->all());
            $response =  BkashPaymentTokenize::cPayment($request_data_json);
            //$response =  BkashPaymentTokenize::cPayment($request_data_json,1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..

            //store paymentID and your account number for matching in callback request
            // dd($response) //if you are using sandbox and not submit info to bkash use it for 1 response
            if (isset($response['bkashURL'])) return redirect()->away($response['bkashURL']);
            else return redirect()->back()->with('error-alert2', $response['statusMessage']);
        }
    }

    public function callBack(Request $request)
    {
        //dump($request->all());
        //callback request params
        // paymentID=your_payment_id&status=success&apiVersion=1.2.0-beta
        //using paymentID find the account number for sending params

        if ($request->status == 'success') {
            $response = BkashPaymentTokenize::executePayment($request->paymentID);
            //$response = BkashPaymentTokenize::executePayment($request->paymentID, 1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..
            if (!$response) { //if executePayment payment not found call queryPayment
                $response = BkashPaymentTokenize::queryPayment($request->paymentID);
                //$response = BkashPaymentTokenize::queryPayment($request->paymentID,1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..
            }

            if (isset($response['statusCode']) && $response['statusCode'] == "0000" && $response['transactionStatus'] == "Completed") {

                // $invoice_code = $response['merchantInvoiceNumber'];

                //dump($response);
                if (isset($response['trxID'])) {
                    $invoiceID = $response['merchantInvoiceNumber'];
                    Invoice::where(['code' => $invoiceID])->update(['status' => 1]);
                    PaymentHistory::create([
                        'invoice_id' => $invoiceID,
                        'payment_id' => $response['paymentID'],
                        'amount' => $response['amount'],
                        'trx_id' => $response['trxID'],
                        'payment_number' => $response['customerMsisdn'],
                        'gateway_name' => 'Bkash',
                    ]);
                    $invoice = Invoice::where('code', $invoiceID)->first();
                    $user = User::where('phone_number', $invoice->phone_number)->first();
                    if ($user) {
                        $credentials = [
                            'phone_number' => $user->phone_number,
                            'password' => $user->verification_code,
                        ];
                        auth()->attempt($credentials);
                    } else {
                        $code = rand(100000, 999999);
                        $user = User::create([
                            'name' => 'Anonymous',
                            'phone_number' => $invoice->phone_number,
                            'email' => rand(1111111111, 9999999999) . '@gmail.com',
                            'password' => Hash::make($code),
                            'verification_code' => $code,
                        ]);
                        $credentials = [
                            'phone_number' => $invoice->phone_number,
                            'password' => $code,
                        ];

                        fsendEvent('Purchase', [
                            'email' => hash('sha256', $invoice->phone_number),
                            'phone' => hash('sha256', $invoice->phone_number),
                            'client_ip_address' => request()->ip(),
                            'client_user_agent' => request()->header('User-Agent')
                        ]);
                        auth()->attempt($credentials);
                    }
                }




                /*
                 * for refund need to store
                 * paymentID and trxID
                 * */
                // echo "thanks";
                // return BkashPaymentTokenize::success('Thank you for your payment', $response['trxID']);

                return redirect(route('profile.index'))->with(['alert' => 'success', 'title' => 'Payment Successful', 'muted' => 'Thank you for buy the package']);
            }
            //return BkashPaymentTokenize::failure($response['statusMessage']);
        } else if ($request->status == 'cancel') {
            //echo "Cancel";
            return view('Iframe.fail')->with([
                'errorMessage' => 'Payment Cancel'
            ]);
        } else {
            //echo "failed";
            return view('Iframe.fail')->with([
                'errorMessage' => 'Payment Failed'
            ]);
        }
    }

    public function searchTnx($trxID)
    {
        //response
        return BkashPaymentTokenize::searchTransaction($trxID);
        //return BkashPaymentTokenize::searchTransaction($trxID,1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..
    }

    // public function refund(Request $request)
    // {
    //     $paymentID = 'Your payment id';
    //     $trxID = 'your transaction no';
    //     $amount = 5;
    //     $reason = 'this is test reason';
    //     $sku = 'abc';
    //     //response
    //     return BkashRefundTokenize::refund($paymentID, $trxID, $amount, $reason, $sku);
    //     //return BkashRefundTokenize::refund($paymentID,$trxID,$amount,$reason,$sku, 1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..
    // }
    // public function refundStatus(Request $request)
    // {
    //     $paymentID = 'Your payment id';
    //     $trxID = 'your transaction no';
    //     return BkashRefundTokenize::refundStatus($paymentID, $trxID);
    //     //return BkashRefundTokenize::refundStatus($paymentID,$trxID, 1); //last parameter is your account number for multi account its like, 1,2,3,4,cont..
    // }
}
