<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Invoice;
use App\Models\Package;
use App\Models\MegaBundle;
use App\Models\StaticPage;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class HomeController extends Controller
{
    public function index()
    {
        $packages = Package::where('status', 1)->get();
        $megabundles = MegaBundle::where('status', 1)->with('package', 'limitedpackage')->get();
        $featured_packages = Package::where('status', 1)->where('featured', 1)->get();
        return view('home', compact('packages', 'megabundles', 'featured_packages'));
    }

    public function staticpage($slug)
    {
        $page = StaticPage::where('slug', $slug)->first();
        return view('staticpage', compact('page'));
    }
    public function checkout(Request $request, $type, $product_id)
    {
        // dump($request->all(), $type, $product_id);
        if ($type == 1) {
            $data = Package::where('id', $product_id)->with('active_prices')->firstorFail();
        } else if ($type == 2) {
            $data = MegaBundle::where('id', $product_id)->with('active_prices')->firstorFail();
        } else {
            return redirect()->route('home');
        }
        return view('checkout', compact('type', 'data'));
    }
    public function paymentpage(Request $request)
    {
        $rules = [
            'phone_number' => 'required|numeric',
            'product_id' => 'required|numeric',
            'type' => 'required|numeric',
            'time_period' => 'required|numeric',
        ];
        $custommessages = [
            'phone_number.required' => 'Please enter your phone number',
            'phone_number.numeric' => 'Please enter a valid phone number',
            'product_id.required' => 'Please select a package',
            'product_id.numeric' => 'Please select a valid package',
            'time_period.required' => 'Please select time period',
            'time_period.numeric' => 'Please select a valid time period',

        ];
        $request->validate($rules, $custommessages);
        $invoice = new Invoice();
        $code = date('d') .  Str::upper(Str::random(2)) . rand(11, 99);
        $invoice->code =  $code;
        $invoice->phone_number = $request->phone_number;
        $invoice->product_id = $request->product_id;
        $invoice->type = $request->type;
        $invoice->time_period = $request->time_period;

        fsendEvent('AddToCart', [
            'email' => hash('sha256', $request->phone_number),
            'phone' => hash('sha256', $request->phone_number),
            'client_ip_address' => request()->ip(),
            'client_user_agent' => request()->header('User-Agent')
        ]);


        $invoice->save();
        return redirect(route('invoice', ['invoice_code' => $code]));
    }
    public function invoice($code)
    {
        $invoice = Invoice::where('code', $code)->first();
        $type = $invoice->type == 1 ? 'Package' : 'Mega Bundle';
        $title = $invoice->type == 1 ? $invoice->package->title : $invoice->bundle->title;
        //$price = $invoice->type == 1 ? $invoice->package->new_price : $invoice->bundle->new_price;
        $time_period = $invoice->type == 1 ? $invoice->package_time_period : $invoice->mega_bundle_time_period;
        // $total_price = $invoice->month_available == 0 ? $price : $price * $invoice->month_available;
        // $available_for = $invoice->month_available == 0 ? 'Unlimited Time' : $invoice->month_available . ' Months';
        //dump($invoice, $type, $title, $time_period);
        return view('invoice', compact('invoice', 'type', 'title', 'time_period'));
    }

    public function login()
    {
        return view('login');
    }
    public function loginSubmit(Request $request)
    {

        $request->validate([
            'phone_number' => 'required',
        ]);
        $user = User::where('phone_number', $request->phone_number)->first();
        $now = Carbon::now();
        if ($user) {
            $user_old_code_expired = $user->verification_code_expired;
            if ($user_old_code_expired == null || Carbon::parse($user->verification_code_expired)->addMinutes(2) < $now) {
                $otp = random_int(100000, 999999);
                $expiryTime = $now->copy()->addMinutes(5);
                $updated = User::where('id', $user->id)->update([
                    'password' => Hash::make($otp),
                    'verification_code' => $otp,
                    'verification_code_expired' => $expiryTime,
                ]);
                sendSMSOTP($user->phone_number, $otp);
                return redirect(route('verification', ['phone_number' => $request->phone_number]));
            } else {
                Carbon::parse($user->verification_code_expired)->addMinutes(2)->format('h:i A');
                return back()->withErrors([
                    'phone_number' => 'Please wait for ' . Carbon::parse($user->verification_code_expired)->format('h:i A') . ' to send code again',
                ]);
            }
        } else {
            return back()->withErrors([
                'phone_number' => 'Please buy any package first',
            ]);
        }
    }
    public function verification($phone_number)
    {
        return view('verificationpage', compact('phone_number'));
    }
    public function verificationSubmit(Request $request)
    {
        $validatedData = $request->validate([
            'phone_number' => 'required',
            'verification_code' => 'required|numeric',
        ]);
        $credentials = [
            'phone_number' => $request->phone_number,
            'password' => $request->verification_code,
        ];
        if (auth()->attempt($credentials)) {
            return redirect(route('profile.index'));
        }
        return back()->withErrors([
            'verification_code' => 'Invalid verification code',
        ]);
    }
    public function logout(Request $request)
    {
        Auth::logout();
        return redirect(route('login'))
            ->with(['alert' => 'success', 'title' => 'Logout successful', 'muted' => 'Hope you will come back again']);
    }
    public function test()
    {
        echo 'test';
        // dump(sendSMSOTP('01610432417', '888658'));
    }
    public function search(Request $request)
    {
        $request->validate([
            'q' => 'required|min:3',
        ]);
        $packages = Package::where('title', 'like', '%' . $request->q . '%')->get();
        return view('search', compact('packages'));
    }
    public function testcart()
    {
        $content = fsendEvent('AddToCart', [
            'email' => hash('sha256', 'amitanto94@gmail.com'),
            'phone' => hash('sha256', 01610432417),
            'client_ip_address' => request()->ip(),
            'client_user_agent' => request()->header('User-Agent')
        ]);
        return view('test', compact('content'));
    }

    public function testpurchase()
    {
        $content = fsendEvent('Purchase', [

            'email' => hash('sha256', 'amitanto94@gmail.com'),
            'phone' => hash('sha256', 01610432417),
            'client_ip_address' => request()->ip(),
            'client_user_agent' => request()->header('User-Agent')
        ], 100);
        return view('test', compact('content'));
    }
}
