<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->short_name ?? 'test',
            'website' => $this->domain ?? 'https://www.freepik.com',
            'cookies' => $this->cookies->map(function ($cookie) {
                return json_decode($cookie->cookie_value);
            }),
            // 'block_links' => $this->blockLink->pluck('block_link')
        ];
    }
}
