<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = [
        'code',
        'phone_number',
        'product_id',
        'type',
        'status',
        'send_sms',
        'month_available',

    ];
    public function package()
    {
        return $this->belongsTo(Package::class, 'product_id');
    }
    public function bundle()
    {
        return $this->belongsTo(MegaBundle::class, 'product_id');
    }
    public function package_time_period()
    {
        return $this->belongsTo(PackagePrice::class, 'time_period', 'id');
    }
    public function mega_bundle_time_period()
    {
        return $this->belongsTo(MegaBundlePrice::class, 'time_period', 'id');
    }
}
