<?php

namespace App\Models;

use App\Models\MegaBundlePackage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class MegaBundle extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'summary',
        'details',
        'image',
        'old_price',
        'new_price',
        'status',

    ];
    public function packages()
    {
        return $this->hasMany(MegaBundlePackage::class, 'mega_bundle_id', 'id');
    }
    public function package()
    {
        return $this->belongsToMany(Package::class, 'mega_bundle_package', 'mega_bundle_id', 'package_id');
    }
    public function limitedpackage()
    {
        return $this->belongsToMany(Package::class, 'mega_bundle_package', 'mega_bundle_id', 'package_id')->limit(4);
    }
    public function prices()
    {
        return $this->hasMany(MegaBundlePrice::class);
    }
    public function active_prices()
    {
        return $this->hasMany(MegaBundlePrice::class)->where('status', 1);
    }


    //total sell from invoice status 1


    public function paid_invoices()
    {

        return $this->hasMany(Invoice::class, 'product_id')->where([
            'status' => 1,
            'type' => 2
        ]);
    }
}
