<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'short_name',
        'website',
        'summary',
        'details',
        'image',
        'old_price',
        'new_price',
        'status',
        'type',
        'featured',
        'storage_link',

    ];

    public function paid_invoices()
    {

        return $this->hasMany(Invoice::class, 'product_id')->where([
            'status' => 1,
            'type' => 1
        ]);
    }
    public function cookies()
    {
        return $this->hasMany(PackageCookies::class);
    }

    public function lastupdatedcookie()
    {
        return $this->hasMany(PackageCookies::class)->where('status', 1)->orderBy('updated_at', 'desc')->limit(1);
    }
    public function credentials()
    {
        return $this->hasMany(PackageCredential::class);
    }

    public function blockLink()
    {
        return $this->hasMany(PackageBlockLink::class);
    }
    public function prices()
    {
        return $this->hasMany(PackagePrice::class);
    }
    public function active_prices()
    {
        return $this->hasMany(PackagePrice::class)->where('status', 1);
    }
}
