<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PackageCookies extends Model
{
    protected $fillable = ['package_id', 'cookie_name', 'cookie_value', 'status'];

    protected $rules = [
        'package_id' => 'unique:package_cookies,package_id',
    ];

    public function package()
    {
        return $this->belongsTo(Package::class)->where('type', 1);
    }
    public function blankpackage()
    {
        return $this->belongsTo(Package::class)->where('type', 1)->doesntHave('cookies');
    }
}
