<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id(); // For auto-incrementing ID
            $table->string('title'); // title field
            $table->string('short_name'); // description field
            $table->string('website')->nullable();
            $table->string('slug')->unique(); // slug field (unique)
            $table->text('summary'); // summary field
            $table->text('details'); // details field
            $table->string('image')->nullable(); // image field
            $table->decimal('old_price', 10, 2); // old_price field with 2 decimal places
            $table->decimal('new_price', 10, 2); // new_price field with 2 decimal places
            $table->boolean('status')->default(0);
            // ALTER TABLE `packages` ADD `featured` INT NULL DEFAULT '0' AFTER `status`;
            $table->boolean('featured')->default(0);
            $table->boolean('type')->default(0);

            $table->string('storage_link')->nullable(); // storage_link field

            $table->timestamps(); // created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
