<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mega_bundles', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique(); // slug field (unique)
            $table->text('summary'); // summary field
            $table->text('details'); // details field
            $table->string('image')->nullable(); // image field
            $table->decimal('old_price', 10, 2); // old_price field with 2 decimal places
            $table->decimal('new_price', 10, 2); // new_price field with 2 decimal places
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mega_bundles');
    }
};
