<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mega_bundle_package', function (Blueprint $table) {
            $table->id();
            $table->foreignId('mega_bundle_id')->constrained('mega_bundles')->onDelete('cascade');
            $table->foreignId('package_id')->constrained('packages')->onDelete('cascade');
            // Unique constraint to prevent duplicate package-website pairs
            $table->unique(['mega_bundle_id', 'package_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mega_bundle_packages');
    }
};
