<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mega_bundle_prices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('mega_bundle_id')->constrained('mega_bundles')->onDelete('cascade');
            $table->string('title');
            $table->string('day');
            $table->integer('price');
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mega_bundle_prices');
    }
};
