<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_credentials', function (Blueprint $table) {
            $table->id();
            $table->integer('package_id')->constrained('packages')->onDelete('cascade');
            $table->string('credential_name');
            $table->string('email');
            $table->string('password');
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_credentials');
    }
};
