<x-layouts.main>
    <div class="container-xl mb-2">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h1 class="page-title">
                </h1>
            </div>
        </div>
    </div>
    <div class="container container-tight py-4">
        <form class="card card-md" action="{{ route('paymentpage') }}" method="post" autocomplete="off" novalidate="">
			<input type="hidden" name="type" value="{{ $type }}">
			
            @csrf
            <div class="card-body">
                {{-- <h2 class="card-title text-center mb-4">Create new account</h2> --}}
                <div class="mb-3">
                    <label class="form-label">Phone Number</label>
                    <div class="input-group mb-2">
                        <span class="input-group-text">
                            +88
                        </span>
                        <input type="text" class="form-control" placeholder="01711111111" name="phone_number"
                            value="{{ auth()->user()->phone_number ?? '' }}">
                    </div>
                    @error('phone_number')
                        <div class="is-invalid"></div>
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label"> @if ($type == 1) Package Details @else Mega Bundle Details @endif</label>
                    <div class="form-selectgroup form-selectgroup-boxes d-flex flex-column">
                        <label class="form-selectgroup-item flex-fill">
                            <input type="radio" name="product_id" value="{{ $data->id }}"
                                class="form-selectgroup-input" checked="">
                            <div class="form-selectgroup-label d-flex align-items-center p-3">
                                <div class="me-3">
                                    <span class="form-selectgroup-check"></span>
                                </div>
                                <div>
                                    <div class="font-weight-medium"><b>{{ $data->title }}</b></div>
                                    {{-- <div class="text-secondary">BDT {{ $data->new_price }}</div> --}}
                                </div>
                            </div> 
                        </label>
                    </div>
                </div>

				{{-- <input type="select" name="month_available" value="0"> --}}
                <div class="mb-3">
                    <label class="form-label">Time Period </label>
                    <div class="form-selectgroup form-selectgroup-boxes d-flex flex-column">
                        <label class="form-selectgroup-item flex-fill">
                            <select class="form-select" name="time_period" required="required">
                                <option value="">Select One</option>
                                @foreach ($data->active_prices as $price)
                                    <option value="{{ $price->id }}">{{ $price->title }} - {{ $price->price }} TK</option>
                                @endforeach
                            </select>

                            @error('time_period')
                            <div class="is-invalid"></div>
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                        </label>
                    </div>
                </div>
				
                <div class="form-footer">
                    <button type="submit" class="btn btn-primary w-100">Go To Payment Page</button>
                </div>
            </div>
        </form>
    </div>
</x-layouts.main>
