
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title>{{ config('app.name') }} | {!! custom_setings()->site_title !!}</title>

    <meta name="msapplication-TileColor" content="#066fd1"/>
    <meta name="theme-color" content="#066fd1"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="mobile-web-app-capable" content="yes"/>
    <meta name="HandheldFriendly" content="True"/>
    <meta name="MobileOptimized" content="320"/>
   
    <link rel="apple-touch-icon" sizes="57x57" href="{{asset('favicon')}}/apple-icon-57x57.png">
<link rel="apple-touch-icon" sizes="60x60" href="{{asset('favicon')}}/apple-icon-60x60.png">
<link rel="apple-touch-icon" sizes="72x72" href="{{asset('favicon')}}/apple-icon-72x72.png">
<link rel="apple-touch-icon" sizes="76x76" href="{{asset('favicon')}}/apple-icon-76x76.png">
<link rel="apple-touch-icon" sizes="114x114" href="{{asset('favicon')}}/apple-icon-114x114.png">
<link rel="apple-touch-icon" sizes="120x120" href="{{asset('favicon')}}/apple-icon-120x120.png">
<link rel="apple-touch-icon" sizes="144x144" href="{{asset('favicon')}}/apple-icon-144x144.png">
<link rel="apple-touch-icon" sizes="152x152" href="{{asset('favicon')}}/apple-icon-152x152.png">
<link rel="apple-touch-icon" sizes="180x180" href="{{asset('favicon')}}/apple-icon-180x180.png">
<link rel="icon" type="image/png" sizes="192x192"  href="{{asset('favicon')}}/android-icon-192x192.png">
<link rel="icon" type="image/png" sizes="32x32" href="{{asset('favicon')}}/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="{{asset('favicon')}}/favicon-96x96.png">
<link rel="icon" type="image/png" sizes="16x16" href="{{asset('favicon')}}/favicon-16x16.png">
<link rel="manifest" href="{{asset('favicon')}}/manifest.json">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="msapplication-TileImage" content="{{asset('favicon')}}/ms-icon-144x144.png">
<meta name="theme-color" content="#ffffff">
    

    <meta name="description" content="{!! custom_setings()->site_description !!}"/>
@if (request()->routeIs('checkout'))
    <meta name="robots" content="index">    
@endif
    @vite(['resources/js/app.js'])


{!! custom_setings()->header_code !!}

  </head>
  <body data-bs-theme="dark">
    
    <div class="page">
      <!-- Navbar -->
      <div class="sticky-top">
        <header class="navbar navbar-expand-md sticky-top d-print-none" >
          <div class="container-xl">
            {{-- <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
              <span class="navbar-toggler-icon"></span>
            </button> --}}
            <div class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal pe-0 pe-md-3">
              <a href="{{ route('home') }}">
                <span class="navbar-brand-image">{{ config('app.name') }}</span>
              </a>
            </div>
            <div class="navbar-nav flex-row order-md-last">
              {{-- <div class="nav-item d-none d-md-flex me-3">
                <div class="btn-list">
                  @if (Auth::check())
                  <a href="{{ route('profile.index') }}" class="btn">
                    Profile
                  </a>
                  @else
                  <a href="{{ route('login') }}" class="btn">
                    
                    Login
                  </a>
                  @endif
                </div>
              </div> --}}
      
             

              @if (Auth::check())
             

              <div class="nav-item dropdown">
                <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
                  <span class="avatar avatar-sm" style="background-image: url({{ asset('no-user.webp') }})"></span>
                  <div class="d-none d-xl-block ps-2">
                    <div>Profile</div>
                    
                  </div>
                </a>
                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
       
                  <a href="{{ route('profile.index') }}" class="dropdown-item">Profile</a>
                  <a href="{{ route('profile.packages') }}" class="dropdown-item">Packages</a>
                  <a href="{{ route('profile.bundles') }}" class="dropdown-item">Bundle Package</a>
                  <a href="{{ route('logout') }}" class="dropdown-item">Logout</a>
                  {{-- <div class="dropdown-divider"></div>
                  <a href="./settings.html" class="dropdown-item">Settings</a>
                  <a href="./sign-in.html" class="dropdown-item">Logout</a> --}}
                </div>
              </div>

              @else
              <a href="{{ route('login') }}" class="btn">
                
                Login
              </a>
              @endif


            </div>
          </div>
        </header>
       
      </div>
     
      <div class="page-wrapper">

        @if (request()->routeIs('home')  || request()->routeIs('search'))
        <x-search />
            
        @endif
        <!-- Page body -->
        <div class="page-body">
        
            <div class="container-xl">
                {{ $slot }}
            </div>
        </div>
        <footer class="footer footer-transparent d-print-none">
          <div class="container-xl">
              <div class="row text-center align-items-center ">
                  <div class="col-12 col-lg-auto mt-2 mt-lg-0">
                      <ul class="list-inline list-inline-dots mb-0">
                          <li class="list-inline-item">
                              © 2024 {{ config('app.name') }}. All Rights Reserved.
                          </li>
                      </ul>
                  </div>
                  <div class="col-lg-auto ms-lg-auto">
                      <ul class="list-inline list-inline-dots mb-0">
                  @foreach (static_pages() as $item)
                          <li class="list-inline-item"><a wire:navigate href="{{ route('page', $item->slug) }}" class="link-secondary" target="_blank">{{ $item->title }}</a>
                          </li>
                          @endforeach
                          
                      </ul>
                  </div>
  
  
              </div>
          </div>
  
      </footer>
      </div>
    </div>
 



<div class="facebook fixed-kit-button bg-primary">
  <span>

      <a href="https://www.facebook.com/emohol.com.bd" target="_blank" class="text-white"><x-tabler-brand-facebook class="icon"/></a>
  
  </span>

</div>

<div class="instagram fixed-kit-button bg-primary">
  <span>
 
      <a href="https://www.instagram.com/emohol.com.bd" target="_blank" class="text-white"><x-tabler-brand-instagram class="icon"/></a>
  
  </span>

</div>

<div class="whatsapp fixed-kit-button bg-primary">
      <span>
        <a href="https://wa.me/8801705114070" target="_blank" class="text-white"><x-tabler-brand-whatsapp class="icon"/></a>
      
      </span>

  </div>


    {{-- <script src="https://static.elfsight.com/platform/platform.js" async></script>
    <div class="elfsight-app-2d57d66c-eb9b-4c99-ade2-fe1c47c158e9" data-elfsight-app-lazy></div> --}}

</body>
</html>