<x-layouts.main>

    <x-slider :packages="$featured_packages"/>
       <div class="container-xl mt-2">
        <div class="row g-2 align-items-center">
            <div class="col text-center my-2">
                <h2>Mega Bundle</h2>
            </div>
        </div>
    </div>
    <div class="row row-cards row-deck mb-2">
        @foreach ($megabundles as $megabundle)
            <div class="col-md-6 col-lg-3">
                <div class="card card-stacked">
                    <a href="{{ route('megabundle.show', $megabundle->slug) }}">
                        @if ($megabundle->image)
                            <div class="img-responsive img-responsive-4x3 card-img-top"
                                style="background-image: url({{ asset('storage/' . $megabundle->image) }})"></div>
                        @else
                            <div class="img-responsive img-responsive-4x3 card-img-top"
                                style="background-image: url({{ 'https://placehold.co/400x300' }})"></div>
                        @endif
                    </a>

                   
                    <div class="card-body">
                        <h3 class="card-title m-0"><a
                                href="{{ route('megabundle.show', $megabundle->slug) }}">{{ $megabundle->title }}</a></h3>
                        <h4 class="m-0">Price : {{ $megabundle->new_price }}/-</h4>
                        <h4 class="m-o"><i>Total {{ $megabundle->package->count() }} tools available</i></h4>

                        <ul class="list-unstyled lh-lg">
             
                            @foreach ($megabundle->limitedpackage as $package)
          
                            <li>
                                
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="icon me-1 text-success">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M5 12l5 5l10 -10"></path>
                                </svg>
                                {{ $package->short_name }}
                            </li>

                            @endforeach
                        </ul>

                        
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('checkout', ['type'=>2,'product_id' => $megabundle->id]) }}" class="btn btn-primary w-100">Buy
                            Now</a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>



    <div class="container-xl ">
        <div class="row g-2 align-items-center">
            <div class="col text-center my-2">
                <h2>Our Package</h2>
            </div>
        </div>
    </div>
    <div class="row row-cards row-deck">
        @foreach ($packages as $package)
            <div class="col-6 col-md-6 col-lg-3">
                <div class="card">
                    <a href="{{ route('package.show', $package->slug) }}">
                        @if ($package->image)
                            <div class="img-responsive img-responsive-4x3 card-img-top"
                                style="background-image: url({{ asset('storage/' . $package->image) }})"></div>
                        @else
                            <div class="img-responsive img-responsive-4x3 card-img-top"
                                style="background-image: url({{ 'https://placehold.co/400x300' }})"></div>
                        @endif
                    </a>
                    <div class="card-body">
                        <h3 class="card-title"><a
                                href="{{ route('package.show', $package->slug) }}">{{ $package->title }}</a></h3>
                        <h4 class="tk">Price : {{ $package->new_price }}/-</h4>
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('checkout', ['type'=>1,'product_id' => $package->id]) }}" class="btn btn-primary w-100">Buy
                            Now</a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</x-layouts.main>
