<x-layouts.main>
    <div class="container container-xl py-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card card-md">
                    <div class="card-body">
                        <h2 class="h2 text-center mb-4">My Bundles</h2>
                        <a href="{{ asset('Emohol.zip') }}" class="btn btn-primary " target="_blank">Download Extension</a>
                        <a href="#" class="btn btn-2 btn-primary" data-bs-toggle="modal" data-bs-target="#modal-large">
                          How to access?
                          </a>
                          <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
                              <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                                  <div class="modal-content">
                                      <div class="modal-header">
                              <h5 class="modal-title">How to access?</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body text-center">
                              <iframe width="560" height="315" src="https://www.youtube.com/embed/zQ9rF5cjiz8?si=_C8k2VoNWgDbSzkY" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                          </div>
                          <div class="modal-footer">
                              <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                              
                          </div>
                                  </div>
                              </div>
                          </div>
                        <p class="mt-2">After installing the extension successfully, you can show the access link</p>

             
                            @if ($bundle_invoices->count() == 0)
                                <p>You have no bundles</p>
                            @else
                                @foreach ($bundle_invoices as $invoice)
                                @if ($invoice->updated_at->addDays(intval($invoice->mega_bundle_time_period->day)) > now())
                                    <table class="table table-bordered my-2 border-primary mb-4 access_link_table" style="display:none">
                                        {{-- <table class="table table-bordered my-2 border-primary mb-4 access_link_table" > --}}
                                        <tbody>
                                            <thead>
                                                <tr>
                                                    <td colspan="3" class=" text-white bg-green-lt 	 "><b>{{ $invoice->bundle->title }}</b></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="3" class=" text-white bg-green-lt 	 "> This package will valid for
                                                        {{ $invoice->mega_bundle_time_period->title }}
                                                        <br>
                                                        Expired date :
                                                        {{ $invoice->updated_at->addDays(intval($invoice->mega_bundle_time_period->day))->format('d F, Y') }}
                                                    </td>
                                                <tr>
                                                    <td class="bg-primary">Package Name</td>
                                                    <td class="bg-primary">Logo</td>
                                                    <td class="bg-primary">Access Link</td>
                                                </tr>
                                                </tr>
                                            </thead>
                                        </tbody>
                                        @foreach ($invoice->bundle->package as $package)
                                            <tr>
                                                <td>{{ $package->short_name }}</td>
                                                <td><img src="{{ asset('storage/' . $package->image) }}" alt="Logo" class="img-fluid" width="50" height="30"></td>
                                                {{-- <td><img src="http://emohol-xyz.test/storage/package-logo/01JKN8HCCNBPSAV1EX77R135YP.jpg" alt="Logo" class="img-fluid" width="50" height="30"></td> --}}
                                                <td class="text-center">
                                                    @if ($package->type == 1)
                                                    <a href="{{ $package->website }}" class="btn btn-green btn-md" target="_blank">Click Here</a>
                                                    @elseif ($package->type == 2)
                                                    <a href="#" class="btn btn-2 btn-green " data-bs-toggle="modal" data-bs-target="#modal-simple-{{ $package->id }}">
                                                        Click Here
                                                        </a>
                                                        <div class="modal modal-blur fade" id="modal-simple-{{ $package->id }}" tabindex="-1" role="dialog" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                            <h5 class="modal-title">{{ $package->short_name }}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <table class="table table-bordered">
																<tr>
																	<td colspan="2"><a href="{{ $package->website }}" target="_blank" class="btn btn-primary">Open Website and login</a></td>
																</tr>
                                                                <tr>
                                                                    <td>Email</td>
                                                                    <td>Password</td>
                                                                </tr>
                                                               
																@if ($package->credentials->count() > 0)
																@php
																$data = $package->credentials->random(1);
															@endphp
															
															<tr>
																<td>
																	<div class="mb-3 text-right">
																	  
																		<div class="input-group mb-2">
																			<input type="text" class="form-control" placeholder="email" value="{{ $data[0]->email }}" readonly>
																			<button class="btn" type="button" onclick="copyToClipboard(this)">Copy</button>
																		</div>
																		<small class="text-success copy-message" style="display: none;">Copied successfully!</small>
																	</div>
																	</td>

																	<td>
																		<div class="mb-3">
																		  
																			<div class="input-group mb-2">
																				<input type="text" class="form-control" placeholder="password" value="{{ $data[0]->password }}" readonly>
																				<button class="btn" type="button" onclick="copyToClipboard(this)">Copy</button>
																			</div>
																			<small class="text-success copy-message" style="display: none;">Copied successfully!</small>
																		</div>
																		</td>

														   
															</tr>
																
															
																@endif
                                                            </table>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                                                        </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @else
                                                        @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                @endif
                                @endforeach
                            @endif
                    
                    </div>
                </div>
            </div>
        </div>
    </div>

	<script>
		function copyToClipboard(button) {
			var inputField = button.parentElement.querySelector("input"); // Get input field
			var message = button.closest(".mb-3").querySelector(".copy-message"); // Get success message
		
			inputField.select();
			document.execCommand("copy");
		
			// Show success message
			message.style.display = "inline";
			
			// Hide message after 2 seconds
			setTimeout(() => {
				message.style.display = "none";
			}, 2000);
		}
		</script>
</x-layouts.main>


