<?php

use App\Models\Package;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BkashController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\MegaBundleController;

use function Laravel\Prompts\search;

// Route::get('/', function () {
//     return view('welcome');
// });


Route::controller(HomeController::class)->group(function () {
    Route::get('/', 'index')->name('home');
    Route::get('index', function () {
        return redirect()->route('home');
    });
    Route::get('page/{slug}', 'staticpage')->name('page');
    Route::get('checkout/{type}/{product_id}', 'checkout')->name('checkout');
    Route::post('paymentpage', 'paymentpage')->name('paymentpage');
    Route::get('invoice/{invoice_code}', 'invoice')->name('invoice');
    Route::get('test-sms', 'test')->name('test');
    Route::get('test-1', 'testcart')->name('test1');
    Route::get('test-2', 'testpurchase')->name('test2');
    Route::get('login', 'login')->name('login')->middleware('guest');
    Route::post('login', 'loginSubmit')->name('login.submit')->middleware('guest');
    Route::get('verification/{phone_number}', 'verification')->name('verification')->middleware('guest');
    Route::post('verification', 'verificationSubmit')->name('verification.submit')->middleware('guest');
    Route::get('search', 'search')->name('search');
    Route::get('logout',  'logout')->name('logout');
});

Route::controller(PackageController::class)->group(function () {
    Route::get('package/{package}', 'show')->name('package.show');
});

Route::controller(MegaBundleController::class)->group(function () {
    Route::get('mega-bundle/{slug}', 'show')->name('megabundle.show');
});


Route::controller(BkashController::class)->group(function () {
    // Checkout (IFrame) User Part
    //Route::get('bkash/pay', 'payment')->name('bkash-payment');
    Route::get('bkash/create', 'createPayment')->name('bkash-create');
    Route::get('bkash/execute', 'executePayment')->name('bkash-execute');
    Route::get('bkash/success', 'successPayment')->name('bkash-success');
    Route::get('bkash/fail', 'failPayment')->name('bkash-fail');



    // Checkout (IFrame) Refund Admin Part
    // Route::get('/bkash/refund', 'getRefund')->name('get-refund');
    // Route::post('/bkash/refund', 'refundPayment')->name('bkash-refund');
});


Route::middleware('auth')->group(function () {

    Route::controller(UserController::class)->prefix('profile')->group(function () {
        Route::get('/',  'index')->name('profile.index');
        Route::get('/my-packages',  'packages')->name('profile.packages');
        Route::get('/my-bundles',  'bundles')->name('profile.bundles');
        Route::get('/access-list', 'access_list')->name('access.list');
    });
});



// Payment Routes for bKash
Route::get('/bkash/payment', [App\Http\Controllers\BkashTokenizePaymentController::class, 'index']);
Route::post('/bkash/create-payment', [App\Http\Controllers\BkashTokenizePaymentController::class, 'createPayment'])->name('bkash-create-payment');
Route::get('/bkash/callback', [App\Http\Controllers\BkashTokenizePaymentController::class, 'callBack'])->name('bkash-callBack');

//search payment
Route::get('/bkash/search/{trxID}', [App\Http\Controllers\BkashTokenizePaymentController::class, 'searchTnx'])->name('bkash-serach');

//refund payment routes
// Route::get('/bkash/refund', [App\Http\Controllers\BkashTokenizePaymentController::class, 'refund'])->name('bkash-refund');
// Route::get('/bkash/refund/status', [App\Http\Controllers\BkashTokenizePaymentController::class, 'refundStatus'])->name('bkash-refund-status');




Route::controller(ApiController::class)->middleware('auth')->group(function () {
    Route::get('config-ext', 'configExt')->name('config.ext2');
    Route::get('profile-ext', 'profileExt')->name('profile.ext2');
});
